CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
	IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'v_pdv_vd_rc_cli_conv') THEN 
		DROP VIEW v_pdv_vd_rc_cli_conv;
		RAISE NOTICE 'v_pdv_vd_rc_cli_conv Dropada.';
	END IF;
	
	CREATE VIEW v_pdv_vd_rc_cli_conv 
	AS  select
		rc_cli.cd_emp,
		rc_cli.cd_cli,
		rc_cli.rz_cli,
		rc_cli.nm_fant,
		rc_cli.cgc_cpf,
		rc_cli_conv.ds_conv,
		rc_cli_conv.flag_somente_desc_contrato,
		coalesce(rc_cli.esp_cli, 0::numeric) as esp_cli,
		coalesce(rc_cli_conv_rc_cli.matricula, ''::character varying) as matricula,
		coalesce(rc_cli.exige_senha_compra::numeric, 0::numeric) as exige_senha_compra,
		case
			when rc_cli_conv_rc_cli.sts_cred::numeric = 1::numeric then 'bloqueado'::text
			else 'liberado'::text
		end as sts_cred_conveniado,
		case
			when rc_cli.sts_cred = 0::numeric then
			case
				when rc_cli_conv.conv_habilitado::numeric = 1::numeric then 'bloqueado'::text
				else 'liberado'::text
			end
			else
			case
				when rc_cli.sts_cred = 1::numeric then 'bloqueado'::text
				else 'liberado'::text
			end
		end as sts_cred_convenio,
		rc_cli_conv.perc_desc,
		rc_cli_conv_rc_cli.cd_conv,
		rc_cli_conv_rc_cli.sts_ativo as sts_cli,
		rc_cli_conv.tp_conv,
		rc_cli.cons_final,
		rc_cli_conv.instrucoes,
		coalesce(rc_cli_conv.flag_requer_senha, 0::numeric) as flag_requer_senha,
		coalesce(rc_cli.senha, ''::character varying) as senha,
		coalesce(rc_cli.rot_conv_ext, 0::numeric) as rot_conv_ext,
		coalesce(rc_cli_conv.perc_rec_min_conv, 0::numeric) as perc_rec_min_conv,
		coalesce(rc_cli_conv.perc_rec_max_conv, 0::numeric) as perc_rec_max_conv,
		coalesce(rc_cli_conv_rc_cli.perc_rec_min_conv, 0::numeric::double precision) as perc_rec_min_conveniado,
		coalesce(rc_cli_conv_rc_cli.perc_rec_max_conv, 0::numeric::double precision) as perc_rec_max_conveniado,
		coalesce(rc_cli_conv.qt_max_parc, 0) as qt_max_parc,
		coalesce(rc_cli_conv.vlr_min_parc, 0::numeric) as vlr_min_parc,
		coalesce(rc_cli_conv.qtd_dias_prorrog::numeric, 0::numeric) as qtd_dias_prorrog,
		coalesce(rc_cli_conv.dia_fat, 0::numeric) as dia_fat,
		(case
			coalesce(titular.flag_dependente_comp_limite_titular, 0)
			when 1 then coalesce(conv_titular.vlr_cred, 0.00::double precision)
			else coalesce(rc_cli_conv_rc_cli.vlr_cred, 0.00::double precision)
		end) as vlr_cred,
		(case
			coalesce(titular.flag_dependente_comp_limite_titular, 0)
			when 1 then coalesce(conv_titular.vlr_deb, 0.00::double precision)
			else coalesce(rc_cli_conv_rc_cli.vlr_deb, 0.00::double precision)
		end) as vlr_deb,
		(case
			coalesce(titular.flag_dependente_comp_limite_titular, 0)
			when 1 then coalesce(conv_titular.vlr_deb_futuro, 0.00::double precision)
			else coalesce(rc_cli_conv_rc_cli.vlr_deb_futuro, 0.00::double precision)
		end) as vlr_deb_futuro,
		coalesce(titular.flag_dependente_comp_limite_titular, 0) as flag_dependente_comp_limite_titular,
		(case
			coalesce(depende.cd_cli_titular, 0)
			when 0 then 0
			else 1
		end) as ehdependente,
		coalesce(depende.cd_cli_titular, 0) as cd_cli_titular,
		RC_CLI_CONV_RC_CLI.TP_LIMITE_ROTATIVO,
		rc_cli_conv.flag_libera_limite_compra
		,rc_cli_conv.vlr_acima_parc_extra
		,rc_cli_conv.num_max_parc_extra
		,rc_cli_conv.conv_habilitado
	from
		rc_cli
	left join rc_cli_conv_rc_cli on rc_cli.cd_cli = rc_cli_conv_rc_cli.cd_cli::numeric
		and rc_cli.cd_emp = rc_cli_conv_rc_cli.cd_emp::numeric
	left join rc_cli_conv on rc_cli_conv_rc_cli.cd_conv::numeric = rc_cli_conv.cd_conv and rc_cli.cd_emp = rc_cli_conv.cd_emp
	left join rc_cli_conv_dependente depende on rc_cli.cd_cli = depende.cd_cli_depend and depende.cd_conv = rc_cli_conv_rc_cli.cd_conv 
	left join rc_cli titular on depende.cd_cli_titular = titular.cd_cli
	left join rc_cli_conv_rc_cli conv_titular on titular.cd_cli = conv_titular.cd_cli::numeric and titular.cd_emp = conv_titular.cd_emp::numeric
														and rc_cli_conv_rc_cli.cd_conv = conv_titular.cd_conv
	where
		rc_cli.sts_cli = 0::numeric;

	ALTER TABLE v_pdv_vd_rc_cli_conv
	  OWNER TO postgres;
		
	RAISE NOTICE 'v_pdv_vd_rc_cli_conv Recriada.';

END; 
-- fim bloco principal versao 12/11/2024
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();